shape = {}

function shape.Calculate()
   local hw = shape.width / 2
   local hh = shape.height / 2
   local r = shape.filletRad
   Line(-hw, -hh + r, -hw, hh - r)
   ArcA(-hw, hh - r, -hw + r, hh - r, math.pi/2)
   Line(-hw + r, hh, hw - r, hh)
   ArcA(hw - r, hh, hw - r, hh - r, math.pi/2)
   Line(hw, hh - r, hw, -hh + r)
   ArcA(hw, -hh + r, hw - r, -hh + r, math.pi/2)
   Line(hw - r, -hh, -hw + r, -hh)
   ArcA(-hw + r, -hh, -hw + r, -hh + r, math.pi/2)
   shw = shape.slotHoriz / 2
   shh = shape.slotVert / 2
   shl = shape.slotLength / 2
   sr = shape.slotDia / 2
   
   Line(-shw - shl, -shh - sr, -shw + shl, -shh - sr)
   ArcA(-shw + shl, -shh - sr, -shw + shl, -shh, -math.pi)
   Line(-shw + shl, -shh + sr, -shw - shl, -shh + sr)
   ArcA(-shw - shl, -shh + sr, -shw - shl, -shh, -math.pi)
   
   Line(shw - shl, -shh - sr, shw + shl, -shh - sr)
   ArcA(shw + shl, -shh - sr, shw + shl, -shh, -math.pi)
   Line(shw + shl, -shh + sr, shw - shl, -shh + sr)
   ArcA(shw - shl, -shh + sr, shw - shl, -shh, -math.pi)
   
   Line(-shw - shl, shh - sr, -shw + shl, shh - sr)
   ArcA(-shw + shl, shh - sr, -shw + shl, shh, -math.pi)
   Line(-shw + shl, shh + sr, -shw - shl, shh + sr)
   ArcA(-shw - shl, shh + sr, -shw - shl, shh, -math.pi)
   
   Line(shw - shl, shh - sr, shw + shl, shh - sr)
   ArcA(shw + shl, shh - sr, shw + shl, shh, -math.pi)
   Line(shw + shl, shh + sr, shw - shl, shh + sr)
   ArcA(shw - shl, shh + sr, shw - shl, shh, -math.pi)

end

AddNumControl("width", "Width", sc.unitLINEAR, 100, 0.1, 10000, "width.png")
AddNumControl("height", "Height", sc.unitLINEAR, 100, 0.1, 10000, "height.png")
AddNumControl("slotHoriz", "Horizontal Slot Spacing", sc.unitLINEAR, 50, 0.1, 10000, "hHole.png")
AddNumControl("slotVert", "Vertical Slot Spacing", sc.unitLINEAR, 50, 0.1, 10000, "vHole.png")
AddNumControl("slotLength", "Slot Length", sc.unitLINEAR, 20, 0.1, 10000, "slotlength.png")
AddNumControl("slotDia", "Slot Diameter", sc.unitLINEAR, 10, 0.1, 10000, "holeDia.png")
AddNumControl("filletRad", "Corner Radius", sc.unitLINEAR, 10, 0.1, 10000, "fillet.png")

